import java.io.*;

public class Main {
  public static void main (String args[]) {
    BufferedReader brIn = new BufferedReader(
      new InputStreamReader(System.in)
    );

    String fileName = "";

    if(args.length < 1){
      System.out.print("Podaj nazwę pliku:");
      try{
        fileName = brIn.readLine();
      }
      catch(IOException e){
        System.out.print("\nBłąd wejścia-wyjścia.");
        return;
      }
    }
    else{
      fileName = args[0];
    }

    File file = new File(fileName);

    if(file.exists()){
      System.out.println("Plik o tej nazwie już istnieje.");
      return;
    }
    RandomAccessFile raf = null;

    try{
      raf = new RandomAccessFile(file, "rw");
    }
    catch(FileNotFoundException e){
      System.out.println("Nie można utworzyć pliku.");
      return;
    }

    String line = "";

    try{
      while(true){
        line = brIn.readLine();
        if("quit".equals(line) || line == null)
          break;
        raf.writeBytes(line + "\n");
      }
      raf.close();
    }
    catch(IOException e){
      System.out.print("\nBłąd wejścia-wyjścia.");
      return;
    }
  }
}
